//---------------------------------------------------------------------------
#include <windows.h>
#include "lang.h"
/*
Pouit:
nast lang z registru, potom zavolat initLang() a langChanded()
do WM_COMMAND dt setLang(cmd)
do WM_INITDIALOG dt setDlgTexts(hDlg,titleId)
vytvoit langChanged() - menu, file filters, invalidate, nemodln dialogy
*/

#ifndef MAXLNGSTR
 #define MAXLNGSTR 1500
#endif
//---------------------------------------------------------------------------
const int MAXLANG=60;
char lang[64];         //nzev jazyka
char *langFile;        //obsah souboru (msto \n jsou \0)
char *lngstr[MAXLNGSTR];    //ukazatele na dky v langFile
char *lngNames[MAXLANG+1];   //nzvy vech jazyk
//-------------------------------------------------------------------------
#define sizeA(A) (sizeof(A)/sizeof(*A))

char *lng(int i, char *s)
{
 return (i>=0 && i<sizeA(lngstr) && lngstr[i]) ? lngstr[i] : s;
}

//ozne cestu
char *cutPath(char *s)
{
 char *t;
 t=strchr(s,0);
 while(t>=s && *t!='\\') t--;
 t++;
 return t;
}

//na fn zape pracovn adres a pid k nmu soubor e
void getExeDir(char *fn, char *e)
{
 GetModuleFileName(0,fn,192);
 strcpy(cutPath(fn), e);
}
//-------------------------------------------------------------------------
static BOOL CALLBACK enumControls(HWND hwnd, LPARAM)
{
 int i=GetDlgCtrlID(hwnd);
 if((i>=300 && i<sizeA(lngstr) || i<11 && i>0) && lngstr[i]){
   SetWindowText(hwnd,lngstr[i]);
 }
 return TRUE;
}

void setDlgTexts(HWND hDlg)
{
 EnumChildWindows(hDlg,(WNDENUMPROC)enumControls,0);
}

void setDlgTexts(HWND hDlg, int id)
{
 char *s=lng(id,0);
 if(s) SetWindowText(hDlg,s);
 setDlgTexts(hDlg);
}

//znovu nati nemodln dialog nebo vytvo nov dialog na pozici x,y
void changeDialog(HWND &wnd, int x,int y,LPCTSTR dlgTempl, DLGPROC dlgProc)
{
 HWND a,w;

 a=GetActiveWindow();
 w=CreateDialog(inst,dlgTempl,0,dlgProc);
 if(wnd){
   RECT rc;
   GetWindowRect(wnd,&rc);
   MoveWindow(w,rc.left,rc.top,rc.right-rc.left,rc.bottom-rc.top,FALSE);
   if(IsWindowVisible(wnd)) ShowWindow(w,SW_SHOW);
   DestroyWindow(wnd);
 }else{
   SetWindowPos(w,0,x,y,0,0,SWP_NOZORDER|SWP_NOSIZE);
 }
 wnd=w;
 if(a) SetActiveWindow(a);
}
//-------------------------------------------------------------------------
static int *subPtr;

//rekurzivn projde menu a zmn nzvy
static void fillPopup(HMENU h)
{
 int i,id,j;
 char *s;
 HMENU sub;
 MENUITEMINFO mii;

 for(i=GetMenuItemCount(h)-1; i>=0; i--){
   id=GetMenuItemID(h,i);
   if(id==29999){
     for(j=0; lngNames[j]; j++){
       InsertMenu(h,0xFFFFFFFF,
         MF_BYPOSITION|(_stricmp(lngNames[j],lang)?0:MF_CHECKED),
         30000+j,lngNames[j]);
     }
     DeleteMenu(h,0,MF_BYPOSITION);
   }else{
     if(id<0 || id>=0xffffffff){
       sub=GetSubMenu(h,i);
       if(sub){
         id=*subPtr++;
         fillPopup(sub);
       }
     }
     s=lng(id,0);
     if(s){
       mii.cbSize=sizeof(MENUITEMINFO);
       mii.fMask=MIIM_TYPE|MIIM_STATE;
       mii.fType=MFT_STRING;
       mii.fState=MFS_ENABLED;
       mii.dwTypeData=s;
       mii.cch= (UINT) strlen(s);
       SetMenuItemInfo(h,i,TRUE,&mii);
     }
   }
 }
}

//nate menu z resource name
//subId jsou sla etzc pro submenu
HMENU loadMenu(char *name, int *subId)
{
 HMENU hMenu= LoadMenu(inst,name);
 subPtr=subId;
 fillPopup(hMenu);
 return hMenu;
}

void loadMenu(HWND hwnd, char *name, int *subId)
{
 if(!hwnd) return;
 HMENU m= GetMenu(hwnd);
 SetMenu(hwnd,loadMenu(name,subId));
 DestroyMenu(m);
}
//-------------------------------------------------------------------------
static void parseLng()
{
 char *s,*d,*e;
 int id,err=0,line=1;

 for(s=langFile; *s; s++){
   if(*s==';' || *s=='#' || *s=='\n' || *s=='\r'){
     //koment
   }else{
     id=(int)strtol(s,&e,10);
     if(s==e){
       if(!err) msg(lng(755,"Error in %s\nLine %d"),lang,line);
       err++;
     }else if(id<0 || id>=sizeA(lngstr)){
       if(!err) msg(lng(756,"Error in %s\nMessage number %d is too big"),lang,id);
       err++;
     }else if(lngstr[id]){
       if(!err) msg(lng(757,"Error in %s\nDuplicated number %d"),lang,id);
       err++;
     }else{
       s=e;
       while(*s==' ' || *s=='\t') s++;
       if(*s=='=') s++;
       lngstr[id]=s;
     }
   }
   for(d=s; *s!='\n' && *s!='\r'; s++){
     if(*s=='\\'){
       s++;
       if(*s=='\r'){
         line++;
         if(s[1]=='\n') s++;
         continue;
       }else if(*s=='\n'){
         line++;
         continue;
       }else if(*s=='0'){
         *s='\0';
       }else if(*s=='n'){
         *s='\n';
       }else if(*s=='r'){
         *s='\r';
       }else if(*s=='t'){
         *s='\t';
       }
     }
     *d++=*s;
   }
   if(*s!='\r' || s[1]!='\n') line++;
   *d='\0';
 }
}
//-------------------------------------------------------------------------
void scanLangDir()
{
 int n;
 HANDLE h;
 WIN32_FIND_DATA fd;
 char buf[256];

 lngNames[0]="English";
 getExeDir(buf,"language\\*.lng");
 h = FindFirstFile(buf,&fd);
 if(h!=INVALID_HANDLE_VALUE){
  n=1;
  do{
   if(!(fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)){
     int len= (int) strlen(fd.cFileName)-4;
     if(len>0){
       char *s= new char[len+1];
       memcpy(s,fd.cFileName,len);
       s[len]='\0';
       lngNames[n++]=s;
     }
   }
  }while(FindNextFile(h,&fd) && n<MAXLANG);
  FindClose(h);
 }
}
//-------------------------------------------------------------------------
static void loadLang()
{
 memset(lngstr,0,sizeof(lngstr));
 char buf[256];
 GetModuleFileName(0,buf,sizeof(buf)-strlen(lang)-14);
 strcpy(cutPath(buf), "language\\");
 char *fn=strchr(buf,0);
 strcpy(fn,lang);
 strcat(buf,".lng");
 HANDLE f=CreateFile(buf,GENERIC_READ,FILE_SHARE_READ,0,OPEN_EXISTING,0,0);
 if(f!=INVALID_HANDLE_VALUE){
   DWORD len=GetFileSize(f,0);
   if(len>10000000){
     msg(lng(753,"File %s is too long"),fn);
   }else{
     delete[] langFile;
     langFile= new char[len+3];
     DWORD r;
     ReadFile(f,langFile,len,&r,0);
     if(r<len){
       msg(lng(754,"Error reading file %s"),fn);
     }else{
       langFile[len]='\n';
       langFile[len+1]='\n';
       langFile[len+2]='\0';
       parseLng();
     }
   }
   CloseHandle(f);
 }
}
//---------------------------------------------------------------------------
int setLang(int cmd)
{
 if(cmd>=30000 && cmd<30000+MAXLANG && lngNames[cmd-30000]){
   strcpy(lang,lngNames[cmd-30000]);
   loadLang();
   langChanged();
   return 1;
 }
 return 0;
}
//---------------------------------------------------------------------------
void initLang()
{
 scanLangDir();
 if(!lang[0]){
   //autodetekce jazyka
   strcpy(lang,"English");
   LANGID id= GetUserDefaultLangID();
   if(id==0x405) strcpy(lang,"esky");
 }
 loadLang();
}
//---------------------------------------------------------------------------

